/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.KeyPair;

public class KeyPairUnmarshaller
implements Unmarshaller<KeyPair, StaxUnmarshallerContext> {
    private static KeyPairUnmarshaller INSTANCE;

    public KeyPair unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        KeyPair.Builder keyPair = KeyPair.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("keyFingerprint", targetDepth)) {
                    keyPair.keyFingerprint(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyMaterial", targetDepth)) {
                    keyPair.keyMaterial(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("keyName", targetDepth)) continue;
                keyPair.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (KeyPair)keyPair.build();
    }

    public static KeyPairUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyPairUnmarshaller();
        }
        return INSTANCE;
    }
}

