/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.transform.UserBucketUnmarshaller;

public class ImageDiskContainerUnmarshaller
implements Unmarshaller<ImageDiskContainer, StaxUnmarshallerContext> {
    private static ImageDiskContainerUnmarshaller INSTANCE;

    public ImageDiskContainer unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ImageDiskContainer.Builder imageDiskContainer = ImageDiskContainer.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Description", targetDepth)) {
                    imageDiskContainer.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeviceName", targetDepth)) {
                    imageDiskContainer.deviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Format", targetDepth)) {
                    imageDiskContainer.format(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnapshotId", targetDepth)) {
                    imageDiskContainer.snapshotId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Url", targetDepth)) {
                    imageDiskContainer.url(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UserBucket", targetDepth)) continue;
                imageDiskContainer.userBucket(UserBucketUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ImageDiskContainer)imageDiskContainer.build();
    }

    public static ImageDiskContainerUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageDiskContainerUnmarshaller();
        }
        return INSTANCE;
    }
}

