/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVolumeAttributeRequestMarshaller
implements Marshaller<Request<DescribeVolumeAttributeRequest>, DescribeVolumeAttributeRequest> {
    public Request<DescribeVolumeAttributeRequest> marshall(DescribeVolumeAttributeRequest describeVolumeAttributeRequest) {
        if (describeVolumeAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumeAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumeAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVolumeAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeVolumeAttributeRequest.attribute()));
        }
        if (describeVolumeAttributeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)describeVolumeAttributeRequest.volumeId()));
        }
        return request;
    }
}

