/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeRegionsRequestMarshaller
implements Marshaller<Request<DescribeRegionsRequest>, DescribeRegionsRequest> {
    public Request<DescribeRegionsRequest> marshall(DescribeRegionsRequest describeRegionsRequest) {
        List<String> describeRegionsRequestRegionNamesList;
        if (describeRegionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRegionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeRegions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeRegionsRequestFiltersList = describeRegionsRequest.filters();
        if (describeRegionsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeRegionsRequestFiltersListValue : describeRegionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeRegionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeRegionsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeRegionsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeRegionsRequestRegionNamesList = describeRegionsRequest.regionNames()) != null) {
            int regionNamesListIndex = 1;
            for (String describeRegionsRequestRegionNamesListValue : describeRegionsRequestRegionNamesList) {
                if (describeRegionsRequestRegionNamesListValue != null) {
                    request.addParameter("RegionName." + regionNamesListIndex, StringUtils.fromString((String)describeRegionsRequestRegionNamesListValue));
                }
                ++regionNamesListIndex;
            }
        }
        return request;
    }
}

