/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeKeyPairsRequestMarshaller
implements Marshaller<Request<DescribeKeyPairsRequest>, DescribeKeyPairsRequest> {
    public Request<DescribeKeyPairsRequest> marshall(DescribeKeyPairsRequest describeKeyPairsRequest) {
        List<String> describeKeyPairsRequestKeyNamesList;
        if (describeKeyPairsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeKeyPairsRequest, "EC2Client");
        request.addParameter("Action", "DescribeKeyPairs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeKeyPairsRequestFiltersList = describeKeyPairsRequest.filters();
        if (describeKeyPairsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeKeyPairsRequestFiltersListValue : describeKeyPairsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeKeyPairsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeKeyPairsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeKeyPairsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeKeyPairsRequestKeyNamesList = describeKeyPairsRequest.keyNames()) != null) {
            int keyNamesListIndex = 1;
            for (String describeKeyPairsRequestKeyNamesListValue : describeKeyPairsRequestKeyNamesList) {
                if (describeKeyPairsRequestKeyNamesListValue != null) {
                    request.addParameter("KeyName." + keyNamesListIndex, StringUtils.fromString((String)describeKeyPairsRequestKeyNamesListValue));
                }
                ++keyNamesListIndex;
            }
        }
        return request;
    }
}

