/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpnStaticRoute
implements ToCopyableBuilder<Builder, VpnStaticRoute> {
    private final String destinationCidrBlock;
    private final String source;
    private final String state;

    private VpnStaticRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.source = builder.source;
        this.state = builder.state;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String source() {
        return this.source;
    }

    public String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationCidrBlock() == null ? 0 : this.destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnStaticRoute)) {
            return false;
        }
        VpnStaticRoute other = (VpnStaticRoute)obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        return other.state() == null || other.state().equals(this.state());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(this.destinationCidrBlock()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String source;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnStaticRoute model) {
            this.setDestinationCidrBlock(model.destinationCidrBlock);
            this.setSource(model.source);
            this.setState(model.state);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(VpnStaticRouteSource source) {
            this.source(source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final void setSource(VpnStaticRouteSource source) {
            this.source(source.toString());
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(VpnState state) {
            this.state(state.toString());
        }

        public VpnStaticRoute build() {
            return new VpnStaticRoute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpnStaticRoute> {
        public Builder destinationCidrBlock(String var1);

        public Builder source(String var1);

        public Builder source(VpnStaticRouteSource var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);
    }
}

