/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeAttachment
implements ToCopyableBuilder<Builder, VolumeAttachment> {
    private final Instant attachTime;
    private final String device;
    private final String instanceId;
    private final String state;
    private final String volumeId;
    private final Boolean deleteOnTermination;

    private VolumeAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.device = builder.device;
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public String device() {
        return this.device;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String state() {
        return this.state;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachTime() == null ? 0 : this.attachTime().hashCode());
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        hashCode = 31 * hashCode + (this.deleteOnTermination() == null ? 0 : this.deleteOnTermination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeAttachment)) {
            return false;
        }
        VolumeAttachment other = (VolumeAttachment)obj;
        if (other.attachTime() == null ^ this.attachTime() == null) {
            return false;
        }
        if (other.attachTime() != null && !other.attachTime().equals(this.attachTime())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        return other.deleteOnTermination() == null || other.deleteOnTermination().equals(this.deleteOnTermination());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachTime() != null) {
            sb.append("AttachTime: ").append(this.attachTime()).append(",");
        }
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String device;
        private String instanceId;
        private String state;
        private String volumeId;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeAttachment model) {
            this.setAttachTime(model.attachTime);
            this.setDevice(model.device);
            this.setInstanceId(model.instanceId);
            this.setState(model.state);
            this.setVolumeId(model.volumeId);
            this.setDeleteOnTermination(model.deleteOnTermination);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(VolumeAttachmentState state) {
            this.state(state.toString());
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public VolumeAttachment build() {
            return new VolumeAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeAttachment> {
        public Builder attachTime(Instant var1);

        public Builder device(String var1);

        public Builder instanceId(String var1);

        public Builder state(String var1);

        public Builder state(VolumeAttachmentState var1);

        public Builder volumeId(String var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

