/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6AddressesListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterface
implements ToCopyableBuilder<Builder, NetworkInterface> {
    private final NetworkInterfaceAssociation association;
    private final NetworkInterfaceAttachment attachment;
    private final String availabilityZone;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final String interfaceType;
    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;
    private final String requesterId;
    private final Boolean requesterManaged;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final List<Tag> tagSet;
    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String description() {
        return this.description;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public String interfaceType() {
        return this.interfaceType;
    }

    public List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public Boolean requesterManaged() {
        return this.requesterManaged;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String status() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.association() == null ? 0 : this.association().hashCode());
        hashCode = 31 * hashCode + (this.attachment() == null ? 0 : this.attachment().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.interfaceType() == null ? 0 : this.interfaceType().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Addresses() == null ? 0 : this.ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.macAddress() == null ? 0 : this.macAddress().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.privateDnsName() == null ? 0 : this.privateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddresses() == null ? 0 : this.privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.requesterId() == null ? 0 : this.requesterId().hashCode());
        hashCode = 31 * hashCode + (this.requesterManaged() == null ? 0 : this.requesterManaged().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.tagSet() == null ? 0 : this.tagSet().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.interfaceType() == null ^ this.interfaceType() == null) {
            return false;
        }
        if (other.interfaceType() != null && !other.interfaceType().equals(this.interfaceType())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.macAddress() == null ^ this.macAddress() == null) {
            return false;
        }
        if (other.macAddress() != null && !other.macAddress().equals(this.macAddress())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.requesterId() == null ^ this.requesterId() == null) {
            return false;
        }
        if (other.requesterId() != null && !other.requesterId().equals(this.requesterId())) {
            return false;
        }
        if (other.requesterManaged() == null ^ this.requesterManaged() == null) {
            return false;
        }
        if (other.requesterManaged() != null && !other.requesterManaged().equals(this.requesterManaged())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.tagSet() == null ^ this.tagSet() == null) {
            return false;
        }
        if (other.tagSet() != null && !other.tagSet().equals(this.tagSet())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.association() != null) {
            sb.append("Association: ").append(this.association()).append(",");
        }
        if (this.attachment() != null) {
            sb.append("Attachment: ").append(this.attachment()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.interfaceType() != null) {
            sb.append("InterfaceType: ").append(this.interfaceType()).append(",");
        }
        if (this.ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.ipv6Addresses()).append(",");
        }
        if (this.macAddress() != null) {
            sb.append("MacAddress: ").append(this.macAddress()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.privateIpAddresses()).append(",");
        }
        if (this.requesterId() != null) {
            sb.append("RequesterId: ").append(this.requesterId()).append(",");
        }
        if (this.requesterManaged() != null) {
            sb.append("RequesterManaged: ").append(this.requesterManaged()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.tagSet() != null) {
            sb.append("TagSet: ").append(this.tagSet()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private NetworkInterfaceAttachment attachment;
        private String availabilityZone;
        private String description;
        private List<GroupIdentifier> groups;
        private String interfaceType;
        private List<NetworkInterfaceIpv6Address> ipv6Addresses;
        private String macAddress;
        private String networkInterfaceId;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses;
        private String requesterId;
        private Boolean requesterManaged;
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private List<Tag> tagSet;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.setAssociation(model.association);
            this.setAttachment(model.attachment);
            this.setAvailabilityZone(model.availabilityZone);
            this.setDescription(model.description);
            this.setGroups(model.groups);
            this.setInterfaceType(model.interfaceType);
            this.setIpv6Addresses(model.ipv6Addresses);
            this.setMacAddress(model.macAddress);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setOwnerId(model.ownerId);
            this.setPrivateDnsName(model.privateDnsName);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setPrivateIpAddresses(model.privateIpAddresses);
            this.setRequesterId(model.requesterId);
            this.setRequesterManaged(model.requesterManaged);
            this.setSourceDestCheck(model.sourceDestCheck);
            this.setStatus(model.status);
            this.setSubnetId(model.subnetId);
            this.setTagSet(model.tagSet);
            this.setVpcId(model.vpcId);
        }

        public final NetworkInterfaceAssociation getAssociation() {
            return this.association;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation association) {
            this.association = association;
        }

        public final NetworkInterfaceAttachment getAttachment() {
            return this.attachment;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType.toString());
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final void setInterfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType.toString());
        }

        public final Collection<NetworkInterfaceIpv6Address> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(NetworkInterfaceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<NetworkInterfacePrivateIpAddress> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final Boolean getRequesterManaged() {
            return this.requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(NetworkInterfaceStatus status) {
            this.status(status.toString());
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<Tag> getTagSet() {
            return this.tagSet;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            this.tagSet(Arrays.asList(tagSet));
            return this;
        }

        public final void setTagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
        }

        @SafeVarargs
        public final void setTagSet(Tag ... tagSet) {
            this.tagSet(Arrays.asList(tagSet));
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterface> {
        public Builder association(NetworkInterfaceAssociation var1);

        public Builder attachment(NetworkInterfaceAttachment var1);

        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(NetworkInterfaceType var1);

        public Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> var1);

        public Builder ipv6Addresses(NetworkInterfaceIpv6Address ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> var1);

        public Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... var1);

        public Builder requesterId(String var1);

        public Builder requesterManaged(Boolean var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

