/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVolumeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyVolumeRequest> {
    private final String volumeId;
    private final Integer size;
    private final String volumeType;
    private final Integer iops;

    private ModifyVolumeRequest(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Integer size() {
        return this.size;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.volumeType() == null ? 0 : this.volumeType().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeRequest)) {
            return false;
        }
        ModifyVolumeRequest other = (ModifyVolumeRequest)((Object)obj);
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        return other.iops() == null || other.iops().equals(this.iops());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.volumeType() != null) {
            sb.append("VolumeType: ").append(this.volumeType()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private Integer size;
        private String volumeType;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeRequest model) {
            this.setVolumeId(model.volumeId);
            this.setSize(model.size);
            this.setVolumeType(model.volumeType);
            this.setIops(model.iops);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final void setVolumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public ModifyVolumeRequest build() {
            return new ModifyVolumeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyVolumeRequest> {
        public Builder volumeId(String var1);

        public Builder size(Integer var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder iops(Integer var1);
    }
}

