/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.SnapshotAttributeName;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifySnapshotAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
    private final String attribute;
    private final CreateVolumePermissionModifications createVolumePermission;
    private final List<String> groupNames;
    private final String operationType;
    private final String snapshotId;
    private final List<String> userIds;

    private ModifySnapshotAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.createVolumePermission = builder.createVolumePermission;
        this.groupNames = builder.groupNames;
        this.operationType = builder.operationType;
        this.snapshotId = builder.snapshotId;
        this.userIds = builder.userIds;
    }

    public String attribute() {
        return this.attribute;
    }

    public CreateVolumePermissionModifications createVolumePermission() {
        return this.createVolumePermission;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public String operationType() {
        return this.operationType;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public List<String> userIds() {
        return this.userIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attribute() == null ? 0 : this.attribute().hashCode());
        hashCode = 31 * hashCode + (this.createVolumePermission() == null ? 0 : this.createVolumePermission().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        hashCode = 31 * hashCode + (this.operationType() == null ? 0 : this.operationType().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.userIds() == null ? 0 : this.userIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest)((Object)obj);
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.createVolumePermission() == null ^ this.createVolumePermission() == null) {
            return false;
        }
        if (other.createVolumePermission() != null && !other.createVolumePermission().equals(this.createVolumePermission())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        if (other.operationType() == null ^ this.operationType() == null) {
            return false;
        }
        if (other.operationType() != null && !other.operationType().equals(this.operationType())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.userIds() == null ^ this.userIds() == null) {
            return false;
        }
        return other.userIds() == null || other.userIds().equals(this.userIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.createVolumePermission() != null) {
            sb.append("CreateVolumePermission: ").append(this.createVolumePermission()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        if (this.operationType() != null) {
            sb.append("OperationType: ").append(this.operationType()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.userIds() != null) {
            sb.append("UserIds: ").append(this.userIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attribute;
        private CreateVolumePermissionModifications createVolumePermission;
        private List<String> groupNames;
        private String operationType;
        private String snapshotId;
        private List<String> userIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotAttributeRequest model) {
            this.setAttribute(model.attribute);
            this.setCreateVolumePermission(model.createVolumePermission);
            this.setGroupNames(model.groupNames);
            this.setOperationType(model.operationType);
            this.setSnapshotId(model.snapshotId);
            this.setUserIds(model.userIds);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
        }

        public final CreateVolumePermissionModifications getCreateVolumePermission() {
            return this.createVolumePermission;
        }

        @Override
        public final Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
            return this;
        }

        public final void setCreateVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final void setOperationType(OperationType operationType) {
            this.operationType(operationType.toString());
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Collection<String> getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @SafeVarargs
        public final void setUserIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
        }

        public ModifySnapshotAttributeRequest build() {
            return new ModifySnapshotAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(SnapshotAttributeName var1);

        public Builder createVolumePermission(CreateVolumePermissionModifications var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder snapshotId(String var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);
    }
}

