/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceAttributeName;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecificationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstanceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
    private final Boolean sourceDestCheck;
    private final String attribute;
    private final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private final Boolean disableApiTermination;
    private final Boolean ebsOptimized;
    private final Boolean enaSupport;
    private final List<String> groups;
    private final String instanceId;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final String kernel;
    private final String ramdisk;
    private final String sriovNetSupport;
    private final String userData;
    private final String value;

    private ModifyInstanceAttributeRequest(BuilderImpl builder) {
        this.sourceDestCheck = builder.sourceDestCheck;
        this.attribute = builder.attribute;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernel = builder.kernel;
        this.ramdisk = builder.ramdisk;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.value = builder.value;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String attribute() {
        return this.attribute;
    }

    public List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernel() {
        return this.kernel;
    }

    public String ramdisk() {
        return this.ramdisk;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String userData() {
        return this.userData;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.attribute() == null ? 0 : this.attribute().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.disableApiTermination() == null ? 0 : this.disableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.enaSupport() == null ? 0 : this.enaSupport().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceInitiatedShutdownBehavior() == null ? 0 : this.instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernel() == null ? 0 : this.kernel().hashCode());
        hashCode = 31 * hashCode + (this.ramdisk() == null ? 0 : this.ramdisk().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest)((Object)obj);
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.disableApiTermination() == null ^ this.disableApiTermination() == null) {
            return false;
        }
        if (other.disableApiTermination() != null && !other.disableApiTermination().equals(this.disableApiTermination())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernel() == null ^ this.kernel() == null) {
            return false;
        }
        if (other.kernel() != null && !other.kernel().equals(this.kernel())) {
            return false;
        }
        if (other.ramdisk() == null ^ this.ramdisk() == null) {
            return false;
        }
        if (other.ramdisk() != null && !other.ramdisk().equals(this.ramdisk())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        return other.value() == null || other.value().equals(this.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.disableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.disableApiTermination()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.enaSupport() != null) {
            sb.append("EnaSupport: ").append(this.enaSupport()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.instanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernel() != null) {
            sb.append("Kernel: ").append(this.kernel()).append(",");
        }
        if (this.ramdisk() != null) {
            sb.append("Ramdisk: ").append(this.ramdisk()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean sourceDestCheck;
        private String attribute;
        private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
        private Boolean disableApiTermination;
        private Boolean ebsOptimized;
        private Boolean enaSupport;
        private List<String> groups;
        private String instanceId;
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private String kernel;
        private String ramdisk;
        private String sriovNetSupport;
        private String userData;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceAttributeRequest model) {
            this.setSourceDestCheck(model.sourceDestCheck);
            this.setAttribute(model.attribute);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setDisableApiTermination(model.disableApiTermination);
            this.setEbsOptimized(model.ebsOptimized);
            this.setEnaSupport(model.enaSupport);
            this.setGroups(model.groups);
            this.setInstanceId(model.instanceId);
            this.setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.setInstanceType(model.instanceType);
            this.setKernel(model.kernel);
            this.setRamdisk(model.ramdisk);
            this.setSriovNetSupport(model.sriovNetSupport);
            this.setUserData(model.userData);
            this.setValue(model.value);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
        }

        public final Collection<InstanceBlockDeviceMappingSpecification> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(String ... groups) {
            this.groups(Arrays.asList(groups));
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernel() {
            return this.kernel;
        }

        @Override
        public final Builder kernel(String kernel) {
            this.kernel = kernel;
            return this;
        }

        public final void setKernel(String kernel) {
            this.kernel = kernel;
        }

        public final String getRamdisk() {
            return this.ramdisk;
        }

        @Override
        public final Builder ramdisk(String ramdisk) {
            this.ramdisk = ramdisk;
            return this;
        }

        public final void setRamdisk(String ramdisk) {
            this.ramdisk = ramdisk;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public ModifyInstanceAttributeRequest build() {
            return new ModifyInstanceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
        public Builder sourceDestCheck(Boolean var1);

        public Builder attribute(String var1);

        public Builder attribute(InstanceAttributeName var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceType(String var1);

        public Builder kernel(String var1);

        public Builder ramdisk(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder userData(String var1);

        public Builder value(String var1);
    }
}

