/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InternetGateway
implements ToCopyableBuilder<Builder, InternetGateway> {
    private final List<InternetGatewayAttachment> attachments;
    private final String internetGatewayId;
    private final List<Tag> tags;

    private InternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.internetGatewayId = builder.internetGatewayId;
        this.tags = builder.tags;
    }

    public List<InternetGatewayAttachment> attachments() {
        return this.attachments;
    }

    public String internetGatewayId() {
        return this.internetGatewayId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachments() == null ? 0 : this.attachments().hashCode());
        hashCode = 31 * hashCode + (this.internetGatewayId() == null ? 0 : this.internetGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGateway)) {
            return false;
        }
        InternetGateway other = (InternetGateway)obj;
        if (other.attachments() == null ^ this.attachments() == null) {
            return false;
        }
        if (other.attachments() != null && !other.attachments().equals(this.attachments())) {
            return false;
        }
        if (other.internetGatewayId() == null ^ this.internetGatewayId() == null) {
            return false;
        }
        if (other.internetGatewayId() != null && !other.internetGatewayId().equals(this.internetGatewayId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachments() != null) {
            sb.append("Attachments: ").append(this.attachments()).append(",");
        }
        if (this.internetGatewayId() != null) {
            sb.append("InternetGatewayId: ").append(this.internetGatewayId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InternetGatewayAttachment> attachments;
        private String internetGatewayId;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetGateway model) {
            this.setAttachments(model.attachments);
            this.setInternetGatewayId(model.internetGatewayId);
            this.setTags(model.tags);
        }

        public final Collection<InternetGatewayAttachment> getAttachments() {
            return this.attachments;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
        }

        @SafeVarargs
        public final void setAttachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public InternetGateway build() {
            return new InternetGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InternetGateway> {
        public Builder attachments(Collection<InternetGatewayAttachment> var1);

        public Builder attachments(InternetGatewayAttachment ... var1);

        public Builder internetGatewayId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

