/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceBlockDeviceMapping
implements ToCopyableBuilder<Builder, InstanceBlockDeviceMapping> {
    private final String deviceName;
    private final EbsInstanceBlockDevice ebs;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public EbsInstanceBlockDevice ebs() {
        return this.ebs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deviceName() == null ? 0 : this.deviceName().hashCode());
        hashCode = 31 * hashCode + (this.ebs() == null ? 0 : this.ebs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping)obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        return other.ebs() == null || other.ebs().equals(this.ebs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.ebs() != null) {
            sb.append("Ebs: ").append(this.ebs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private EbsInstanceBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            this.setDeviceName(model.deviceName);
            this.setEbs(model.ebs);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDevice getEbs() {
            return this.ebs;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
        }

        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder ebs(EbsInstanceBlockDevice var1);
    }
}

