/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceIdSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequestSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetReservedInstancesExchangeQuoteRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
    private final List<String> reservedInstanceIds;
    private final List<TargetConfigurationRequest> targetConfigurations;

    private GetReservedInstancesExchangeQuoteRequest(BuilderImpl builder) {
        this.reservedInstanceIds = builder.reservedInstanceIds;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public List<String> reservedInstanceIds() {
        return this.reservedInstanceIds;
    }

    public List<TargetConfigurationRequest> targetConfigurations() {
        return this.targetConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedInstanceIds() == null ? 0 : this.reservedInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.targetConfigurations() == null ? 0 : this.targetConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteRequest)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteRequest other = (GetReservedInstancesExchangeQuoteRequest)((Object)obj);
        if (other.reservedInstanceIds() == null ^ this.reservedInstanceIds() == null) {
            return false;
        }
        if (other.reservedInstanceIds() != null && !other.reservedInstanceIds().equals(this.reservedInstanceIds())) {
            return false;
        }
        if (other.targetConfigurations() == null ^ this.targetConfigurations() == null) {
            return false;
        }
        return other.targetConfigurations() == null || other.targetConfigurations().equals(this.targetConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedInstanceIds() != null) {
            sb.append("ReservedInstanceIds: ").append(this.reservedInstanceIds()).append(",");
        }
        if (this.targetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(this.targetConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> reservedInstanceIds;
        private List<TargetConfigurationRequest> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteRequest model) {
            this.setReservedInstanceIds(model.reservedInstanceIds);
            this.setTargetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstanceIds() {
            return this.reservedInstanceIds;
        }

        @Override
        public final Builder reservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceIds(String ... reservedInstanceIds) {
            this.reservedInstanceIds(Arrays.asList(reservedInstanceIds));
            return this;
        }

        public final void setReservedInstanceIds(Collection<String> reservedInstanceIds) {
            this.reservedInstanceIds = ReservedInstanceIdSetCopier.copy(reservedInstanceIds);
        }

        @SafeVarargs
        public final void setReservedInstanceIds(String ... reservedInstanceIds) {
            this.reservedInstanceIds(Arrays.asList(reservedInstanceIds));
        }

        public final Collection<TargetConfigurationRequest> getTargetConfigurations() {
            return this.targetConfigurations;
        }

        @Override
        public final Builder targetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        public final void setTargetConfigurations(Collection<TargetConfigurationRequest> targetConfigurations) {
            this.targetConfigurations = TargetConfigurationRequestSetCopier.copy(targetConfigurations);
        }

        @SafeVarargs
        public final void setTargetConfigurations(TargetConfigurationRequest ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
        }

        public GetReservedInstancesExchangeQuoteRequest build() {
            return new GetReservedInstancesExchangeQuoteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteRequest> {
        public Builder reservedInstanceIds(Collection<String> var1);

        public Builder reservedInstanceIds(String ... var1);

        public Builder targetConfigurations(Collection<TargetConfigurationRequest> var1);

        public Builder targetConfigurations(TargetConfigurationRequest ... var1);
    }
}

