/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachmentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EgressOnlyInternetGateway
implements ToCopyableBuilder<Builder, EgressOnlyInternetGateway> {
    private final List<InternetGatewayAttachment> attachments;
    private final String egressOnlyInternetGatewayId;

    private EgressOnlyInternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    public List<InternetGatewayAttachment> attachments() {
        return this.attachments;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachments() == null ? 0 : this.attachments().hashCode());
        hashCode = 31 * hashCode + (this.egressOnlyInternetGatewayId() == null ? 0 : this.egressOnlyInternetGatewayId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressOnlyInternetGateway)) {
            return false;
        }
        EgressOnlyInternetGateway other = (EgressOnlyInternetGateway)obj;
        if (other.attachments() == null ^ this.attachments() == null) {
            return false;
        }
        if (other.attachments() != null && !other.attachments().equals(this.attachments())) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() == null ^ this.egressOnlyInternetGatewayId() == null) {
            return false;
        }
        return other.egressOnlyInternetGatewayId() == null || other.egressOnlyInternetGatewayId().equals(this.egressOnlyInternetGatewayId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachments() != null) {
            sb.append("Attachments: ").append(this.attachments()).append(",");
        }
        if (this.egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(this.egressOnlyInternetGatewayId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InternetGatewayAttachment> attachments;
        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressOnlyInternetGateway model) {
            this.setAttachments(model.attachments);
            this.setEgressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final Collection<InternetGatewayAttachment> getAttachments() {
            return this.attachments;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
        }

        @SafeVarargs
        public final void setAttachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public EgressOnlyInternetGateway build() {
            return new EgressOnlyInternetGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EgressOnlyInternetGateway> {
        public Builder attachments(Collection<InternetGatewayAttachment> var1);

        public Builder attachments(InternetGatewayAttachment ... var1);

        public Builder egressOnlyInternetGatewayId(String var1);
    }
}

