/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpnGatewayIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
    private final List<Filter> filters;
    private final List<String> vpnGatewayIds;

    private DescribeVpnGatewaysRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpnGatewayIds = builder.vpnGatewayIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> vpnGatewayIds() {
        return this.vpnGatewayIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.vpnGatewayIds() == null ? 0 : this.vpnGatewayIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysRequest)) {
            return false;
        }
        DescribeVpnGatewaysRequest other = (DescribeVpnGatewaysRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.vpnGatewayIds() == null ^ this.vpnGatewayIds() == null) {
            return false;
        }
        return other.vpnGatewayIds() == null || other.vpnGatewayIds().equals(this.vpnGatewayIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.vpnGatewayIds() != null) {
            sb.append("VpnGatewayIds: ").append(this.vpnGatewayIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> vpnGatewayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysRequest model) {
            this.setFilters(model.filters);
            this.setVpnGatewayIds(model.vpnGatewayIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getVpnGatewayIds() {
            return this.vpnGatewayIds;
        }

        @Override
        public final Builder vpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGatewayIds(String ... vpnGatewayIds) {
            this.vpnGatewayIds(Arrays.asList(vpnGatewayIds));
            return this;
        }

        public final void setVpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
        }

        @SafeVarargs
        public final void setVpnGatewayIds(String ... vpnGatewayIds) {
            this.vpnGatewayIds(Arrays.asList(vpnGatewayIds));
        }

        public DescribeVpnGatewaysRequest build() {
            return new DescribeVpnGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder vpnGatewayIds(Collection<String> var1);

        public Builder vpnGatewayIds(String ... var1);
    }
}

