/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Volume;
import software.amazon.awssdk.services.ec2.model.VolumeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVolumesResponse> {
    private final List<Volume> volumes;
    private final String nextToken;

    private DescribeVolumesResponse(BuilderImpl builder) {
        this.volumes = builder.volumes;
        this.nextToken = builder.nextToken;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumes() == null ? 0 : this.volumes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesResponse)) {
            return false;
        }
        DescribeVolumesResponse other = (DescribeVolumesResponse)((Object)obj);
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        if (other.volumes() != null && !other.volumes().equals(this.volumes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Volume> volumes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesResponse model) {
            this.setVolumes(model.volumes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume> volumes) {
            this.volumes = VolumeListCopier.copy(volumes);
        }

        @SafeVarargs
        public final void setVolumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeVolumesResponse build() {
            return new DescribeVolumesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumesResponse> {
        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder nextToken(String var1);
    }
}

