/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstanceAvailabilityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private final List<Filter> filters;
    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;
    private final Integer maxResults;
    private final Integer maxSlotDurationInHours;
    private final Integer minSlotDurationInHours;
    private final String nextToken;
    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return this.firstSlotStartTimeRange;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer maxSlotDurationInHours() {
        return this.maxSlotDurationInHours;
    }

    public Integer minSlotDurationInHours() {
        return this.minSlotDurationInHours;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ScheduledInstanceRecurrenceRequest recurrence() {
        return this.recurrence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.firstSlotStartTimeRange() == null ? 0 : this.firstSlotStartTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.maxSlotDurationInHours() == null ? 0 : this.maxSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + (this.minSlotDurationInHours() == null ? 0 : this.minSlotDurationInHours().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.recurrence() == null ? 0 : this.recurrence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.firstSlotStartTimeRange() == null ^ this.firstSlotStartTimeRange() == null) {
            return false;
        }
        if (other.firstSlotStartTimeRange() != null && !other.firstSlotStartTimeRange().equals(this.firstSlotStartTimeRange())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.maxSlotDurationInHours() == null ^ this.maxSlotDurationInHours() == null) {
            return false;
        }
        if (other.maxSlotDurationInHours() != null && !other.maxSlotDurationInHours().equals(this.maxSlotDurationInHours())) {
            return false;
        }
        if (other.minSlotDurationInHours() == null ^ this.minSlotDurationInHours() == null) {
            return false;
        }
        if (other.minSlotDurationInHours() != null && !other.minSlotDurationInHours().equals(this.minSlotDurationInHours())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.recurrence() == null ^ this.recurrence() == null) {
            return false;
        }
        return other.recurrence() == null || other.recurrence().equals(this.recurrence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.firstSlotStartTimeRange() != null) {
            sb.append("FirstSlotStartTimeRange: ").append(this.firstSlotStartTimeRange()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.maxSlotDurationInHours() != null) {
            sb.append("MaxSlotDurationInHours: ").append(this.maxSlotDurationInHours()).append(",");
        }
        if (this.minSlotDurationInHours() != null) {
            sb.append("MinSlotDurationInHours: ").append(this.minSlotDurationInHours()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.recurrence() != null) {
            sb.append("Recurrence: ").append(this.recurrence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private SlotDateTimeRangeRequest firstSlotStartTimeRange;
        private Integer maxResults;
        private Integer maxSlotDurationInHours;
        private Integer minSlotDurationInHours;
        private String nextToken;
        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            this.setFilters(model.filters);
            this.setFirstSlotStartTimeRange(model.firstSlotStartTimeRange);
            this.setMaxResults(model.maxResults);
            this.setMaxSlotDurationInHours(model.maxSlotDurationInHours);
            this.setMinSlotDurationInHours(model.minSlotDurationInHours);
            this.setNextToken(model.nextToken);
            this.setRecurrence(model.recurrence);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final SlotDateTimeRangeRequest getFirstSlotStartTimeRange() {
            return this.firstSlotStartTimeRange;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return this.maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return this.minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest getRecurrence() {
            return this.recurrence;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
        }

        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest var1);

        public Builder maxResults(Integer var1);

        public Builder maxSlotDurationInHours(Integer var1);

        public Builder minSlotDurationInHours(Integer var1);

        public Builder nextToken(String var1);

        public Builder recurrence(ScheduledInstanceRecurrenceRequest var1);
    }
}

