/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ImportImageTask;
import software.amazon.awssdk.services.ec2.model.ImportImageTaskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImportImageTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeImportImageTasksResponse> {
    private final List<ImportImageTask> importImageTasks;
    private final String nextToken;

    private DescribeImportImageTasksResponse(BuilderImpl builder) {
        this.importImageTasks = builder.importImageTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ImportImageTask> importImageTasks() {
        return this.importImageTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.importImageTasks() == null ? 0 : this.importImageTasks().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportImageTasksResponse)) {
            return false;
        }
        DescribeImportImageTasksResponse other = (DescribeImportImageTasksResponse)((Object)obj);
        if (other.importImageTasks() == null ^ this.importImageTasks() == null) {
            return false;
        }
        if (other.importImageTasks() != null && !other.importImageTasks().equals(this.importImageTasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.importImageTasks() != null) {
            sb.append("ImportImageTasks: ").append(this.importImageTasks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ImportImageTask> importImageTasks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportImageTasksResponse model) {
            this.setImportImageTasks(model.importImageTasks);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ImportImageTask> getImportImageTasks() {
            return this.importImageTasks;
        }

        @Override
        public final Builder importImageTasks(Collection<ImportImageTask> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copy(importImageTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importImageTasks(ImportImageTask ... importImageTasks) {
            this.importImageTasks(Arrays.asList(importImageTasks));
            return this;
        }

        public final void setImportImageTasks(Collection<ImportImageTask> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copy(importImageTasks);
        }

        @SafeVarargs
        public final void setImportImageTasks(ImportImageTask ... importImageTasks) {
            this.importImageTasks(Arrays.asList(importImageTasks));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeImportImageTasksResponse build() {
            return new DescribeImportImageTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImportImageTasksResponse> {
        public Builder importImageTasks(Collection<ImportImageTask> var1);

        public Builder importImageTasks(ImportImageTask ... var1);

        public Builder nextToken(String var1);
    }
}

