/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.DhcpOptionsIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDhcpOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDhcpOptionsRequest> {
    private final List<String> dhcpOptionsIds;
    private final List<Filter> filters;

    private DescribeDhcpOptionsRequest(BuilderImpl builder) {
        this.dhcpOptionsIds = builder.dhcpOptionsIds;
        this.filters = builder.filters;
    }

    public List<String> dhcpOptionsIds() {
        return this.dhcpOptionsIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dhcpOptionsIds() == null ? 0 : this.dhcpOptionsIds().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsRequest)) {
            return false;
        }
        DescribeDhcpOptionsRequest other = (DescribeDhcpOptionsRequest)((Object)obj);
        if (other.dhcpOptionsIds() == null ^ this.dhcpOptionsIds() == null) {
            return false;
        }
        if (other.dhcpOptionsIds() != null && !other.dhcpOptionsIds().equals(this.dhcpOptionsIds())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dhcpOptionsIds() != null) {
            sb.append("DhcpOptionsIds: ").append(this.dhcpOptionsIds()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> dhcpOptionsIds;
        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsRequest model) {
            this.setDhcpOptionsIds(model.dhcpOptionsIds);
            this.setFilters(model.filters);
        }

        public final Collection<String> getDhcpOptionsIds() {
            return this.dhcpOptionsIds;
        }

        @Override
        public final Builder dhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptionsIds(String ... dhcpOptionsIds) {
            this.dhcpOptionsIds(Arrays.asList(dhcpOptionsIds));
            return this;
        }

        public final void setDhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
        }

        @SafeVarargs
        public final void setDhcpOptionsIds(String ... dhcpOptionsIds) {
            this.dhcpOptionsIds(Arrays.asList(dhcpOptionsIds));
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public DescribeDhcpOptionsRequest build() {
            return new DescribeDhcpOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDhcpOptionsRequest> {
        public Builder dhcpOptionsIds(Collection<String> var1);

        public Builder dhcpOptionsIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);
    }
}

