/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ZoneNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAvailabilityZonesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
    private final List<Filter> filters;
    private final List<String> zoneNames;

    private DescribeAvailabilityZonesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.zoneNames = builder.zoneNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> zoneNames() {
        return this.zoneNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.zoneNames() == null ? 0 : this.zoneNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.zoneNames() == null ^ this.zoneNames() == null) {
            return false;
        }
        return other.zoneNames() == null || other.zoneNames().equals(this.zoneNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.zoneNames() != null) {
            sb.append("ZoneNames: ").append(this.zoneNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> zoneNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityZonesRequest model) {
            this.setFilters(model.filters);
            this.setZoneNames(model.zoneNames);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getZoneNames() {
            return this.zoneNames;
        }

        @Override
        public final Builder zoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneNames(String ... zoneNames) {
            this.zoneNames(Arrays.asList(zoneNames));
            return this;
        }

        public final void setZoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
        }

        @SafeVarargs
        public final void setZoneNames(String ... zoneNames) {
            this.zoneNames(Arrays.asList(zoneNames));
        }

        public DescribeAvailabilityZonesRequest build() {
            return new DescribeAvailabilityZonesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder zoneNames(Collection<String> var1);

        public Builder zoneNames(String ... var1);
    }
}

