/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Address;
import software.amazon.awssdk.services.ec2.model.AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAddressesResponse> {
    private final List<Address> addresses;

    private DescribeAddressesResponse(BuilderImpl builder) {
        this.addresses = builder.addresses;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.addresses() == null ? 0 : this.addresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse)((Object)obj);
        if (other.addresses() == null ^ this.addresses() == null) {
            return false;
        }
        return other.addresses() == null || other.addresses().equals(this.addresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses() != null) {
            sb.append("Addresses: ").append(this.addresses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Address> addresses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            this.setAddresses(model.addresses);
        }

        public final Collection<Address> getAddresses() {
            return this.addresses;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
        }

        @SafeVarargs
        public final void setAddresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
        }

        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAddressesResponse> {
        public Builder addresses(Collection<Address> var1);

        public Builder addresses(Address ... var1);
    }
}

