/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteVpcEndpointsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteVpcEndpointsRequest> {
    private final List<String> vpcEndpointIds;

    private DeleteVpcEndpointsRequest(BuilderImpl builder) {
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    public List<String> vpcEndpointIds() {
        return this.vpcEndpointIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vpcEndpointIds() == null ? 0 : this.vpcEndpointIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsRequest)) {
            return false;
        }
        DeleteVpcEndpointsRequest other = (DeleteVpcEndpointsRequest)((Object)obj);
        if (other.vpcEndpointIds() == null ^ this.vpcEndpointIds() == null) {
            return false;
        }
        return other.vpcEndpointIds() == null || other.vpcEndpointIds().equals(this.vpcEndpointIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.vpcEndpointIds() != null) {
            sb.append("VpcEndpointIds: ").append(this.vpcEndpointIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> vpcEndpointIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsRequest model) {
            this.setVpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getVpcEndpointIds() {
            return this.vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String ... vpcEndpointIds) {
            this.vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        @SafeVarargs
        public final void setVpcEndpointIds(String ... vpcEndpointIds) {
            this.vpcEndpointIds(Arrays.asList(vpcEndpointIds));
        }

        public DeleteVpcEndpointsRequest build() {
            return new DeleteVpcEndpointsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteVpcEndpointsRequest> {
        public Builder vpcEndpointIds(Collection<String> var1);

        public Builder vpcEndpointIds(String ... var1);
    }
}

