/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFlowLogsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteFlowLogsRequest> {
    private final List<String> flowLogIds;

    private DeleteFlowLogsRequest(BuilderImpl builder) {
        this.flowLogIds = builder.flowLogIds;
    }

    public List<String> flowLogIds() {
        return this.flowLogIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.flowLogIds() == null ? 0 : this.flowLogIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsRequest)) {
            return false;
        }
        DeleteFlowLogsRequest other = (DeleteFlowLogsRequest)((Object)obj);
        if (other.flowLogIds() == null ^ this.flowLogIds() == null) {
            return false;
        }
        return other.flowLogIds() == null || other.flowLogIds().equals(this.flowLogIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(this.flowLogIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> flowLogIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsRequest model) {
            this.setFlowLogIds(model.flowLogIds);
        }

        public final Collection<String> getFlowLogIds() {
            return this.flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        @SafeVarargs
        public final void setFlowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
        }

        public DeleteFlowLogsRequest build() {
            return new DeleteFlowLogsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFlowLogsRequest> {
        public Builder flowLogIds(Collection<String> var1);

        public Builder flowLogIds(String ... var1);
    }
}

