/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFlowLogsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateFlowLogsResponse> {
    private final String clientToken;
    private final List<String> flowLogIds;
    private final List<UnsuccessfulItem> unsuccessful;

    private CreateFlowLogsResponse(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.flowLogIds = builder.flowLogIds;
        this.unsuccessful = builder.unsuccessful;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<String> flowLogIds() {
        return this.flowLogIds;
    }

    public List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.flowLogIds() == null ? 0 : this.flowLogIds().hashCode());
        hashCode = 31 * hashCode + (this.unsuccessful() == null ? 0 : this.unsuccessful().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsResponse)) {
            return false;
        }
        CreateFlowLogsResponse other = (CreateFlowLogsResponse)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.flowLogIds() == null ^ this.flowLogIds() == null) {
            return false;
        }
        if (other.flowLogIds() != null && !other.flowLogIds().equals(this.flowLogIds())) {
            return false;
        }
        if (other.unsuccessful() == null ^ this.unsuccessful() == null) {
            return false;
        }
        return other.unsuccessful() == null || other.unsuccessful().equals(this.unsuccessful());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(this.flowLogIds()).append(",");
        }
        if (this.unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(this.unsuccessful()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private List<String> flowLogIds;
        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsResponse model) {
            this.setClientToken(model.clientToken);
            this.setFlowLogIds(model.flowLogIds);
            this.setUnsuccessful(model.unsuccessful);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getFlowLogIds() {
            return this.flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        @SafeVarargs
        public final void setFlowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
        }

        public final Collection<UnsuccessfulItem> getUnsuccessful() {
            return this.unsuccessful;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
        }

        @SafeVarargs
        public final void setUnsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
        }

        public CreateFlowLogsResponse build() {
            return new CreateFlowLogsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFlowLogsResponse> {
        public Builder clientToken(String var1);

        public Builder flowLogIds(Collection<String> var1);

        public Builder flowLogIds(String ... var1);

        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);
    }
}

