/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignIpv6AddressesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssignIpv6AddressesRequest> {
    private final Integer ipv6AddressCount;
    private final List<String> ipv6Addresses;
    private final String networkInterfaceId;

    private AssignIpv6AddressesRequest(BuilderImpl builder) {
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ipv6AddressCount() == null ? 0 : this.ipv6AddressCount().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Addresses() == null ? 0 : this.ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesRequest)) {
            return false;
        }
        AssignIpv6AddressesRequest other = (AssignIpv6AddressesRequest)((Object)obj);
        if (other.ipv6AddressCount() == null ^ this.ipv6AddressCount() == null) {
            return false;
        }
        if (other.ipv6AddressCount() != null && !other.ipv6AddressCount().equals(this.ipv6AddressCount())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        return other.networkInterfaceId() == null || other.networkInterfaceId().equals(this.networkInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(this.ipv6AddressCount()).append(",");
        }
        if (this.ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.ipv6Addresses()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer ipv6AddressCount;
        private List<String> ipv6Addresses;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesRequest model) {
            this.setIpv6AddressCount(model.ipv6AddressCount);
            this.setIpv6Addresses(model.ipv6Addresses);
            this.setNetworkInterfaceId(model.networkInterfaceId);
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public AssignIpv6AddressesRequest build() {
            return new AssignIpv6AddressesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssignIpv6AddressesRequest> {
        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder networkInterfaceId(String var1);
    }
}

