/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateAddressResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AllocateAddressResponse> {
    private final String publicIp;
    private final String allocationId;
    private final String domain;

    private AllocateAddressResponse(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.domain = builder.domain;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String domain() {
        return this.domain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.allocationId() == null ? 0 : this.allocationId().hashCode());
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse)((Object)obj);
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        return other.domain() == null || other.domain().equals(this.domain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String publicIp;
        private String allocationId;
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            this.setPublicIp(model.publicIp);
            this.setAllocationId(model.allocationId);
            this.setDomain(model.domain);
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final void setDomain(DomainType domain) {
            this.domain(domain.toString());
        }

        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AllocateAddressResponse> {
        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);
    }
}

