/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;

public class DescribeInstancesIterable
implements SdkIterable<DescribeInstancesResponse> {
    private final Ec2Client client;
    private final DescribeInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancesIterable(Ec2Client client, DescribeInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public Iterator<DescribeInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Reservation> reservations() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservations() != null) {
                return response.reservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeInstancesIterable resume(DescribeInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstancesIterable(this.client, (DescribeInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeInstancesResponseFetcher
    implements SyncPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstancesResponse nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesIterable.this.client.describeInstances(DescribeInstancesIterable.this.firstRequest);
            }
            return DescribeInstancesIterable.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

