/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcRequest.getter(CreateVpcRequest::cidrBlock)).setter(CreateVpcRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("CidrBlock").build()}).build();
    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateVpcRequest.getter(CreateVpcRequest::amazonProvidedIpv6CidrBlock)).setter(CreateVpcRequest.setter(Builder::amazonProvidedIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock").unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcRequest.getter(CreateVpcRequest::instanceTenancyAsString)).setter(CreateVpcRequest.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD, INSTANCE_TENANCY_FIELD));
    private final String cidrBlock;
    private final Boolean amazonProvidedIpv6CidrBlock;
    private final String instanceTenancy;

    private CreateVpcRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)((Object)obj);
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcRequest").add("CidrBlock", (Object)this.cidrBlock()).add("AmazonProvidedIpv6CidrBlock", (Object)this.amazonProvidedIpv6CidrBlock()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "AmazonProvidedIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.amazonProvidedIpv6CidrBlock()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcRequest, T> g) {
        return obj -> g.apply((CreateVpcRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean amazonProvidedIpv6CidrBlock;
        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            super(model);
            this.cidrBlock(model.cidrBlock);
            this.amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            this.instanceTenancy(model.instanceTenancy);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcRequest> {
        public Builder cidrBlock(String var1);

        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

