/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.StaleIpPermission;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;
import software.amazon.awssdk.services.ec2.transform.StaleIpPermissionUnmarshaller;

public class StaleSecurityGroupUnmarshaller
implements Unmarshaller<StaleSecurityGroup, StaxUnmarshallerContext> {
    private static final StaleSecurityGroupUnmarshaller INSTANCE = new StaleSecurityGroupUnmarshaller();

    public StaleSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        StaleSecurityGroup.Builder staleSecurityGroup;
        block11: {
            staleSecurityGroup = StaleSecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<StaleIpPermission> staleIpPermissions = null;
            ArrayList<StaleIpPermission> staleIpPermissionsEgress = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    staleSecurityGroup.staleIpPermissions(staleIpPermissions);
                    staleSecurityGroup.staleIpPermissionsEgress(staleIpPermissionsEgress);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("description", targetDepth)) {
                        staleSecurityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupId", targetDepth)) {
                        staleSecurityGroup.groupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupName", targetDepth)) {
                        staleSecurityGroup.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("staleIpPermissions", targetDepth)) {
                        staleIpPermissions = new ArrayList<StaleIpPermission>();
                        continue;
                    }
                    if (context.testExpression("staleIpPermissions/item", targetDepth)) {
                        staleIpPermissions.add(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("staleIpPermissionsEgress", targetDepth)) {
                        staleIpPermissionsEgress = new ArrayList<StaleIpPermission>();
                        continue;
                    }
                    if (context.testExpression("staleIpPermissionsEgress/item", targetDepth)) {
                        staleIpPermissionsEgress.add(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    staleSecurityGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            staleSecurityGroup.staleIpPermissions(staleIpPermissions);
            staleSecurityGroup.staleIpPermissionsEgress(staleIpPermissionsEgress);
        }
        return (StaleSecurityGroup)staleSecurityGroup.build();
    }

    public static StaleSecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

