/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        List<String> reportInstanceStatusRequestReasonCodesList;
        List<String> reportInstanceStatusRequestInstancesList;
        if (reportInstanceStatusRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)reportInstanceStatusRequest, "Ec2Client");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (reportInstanceStatusRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)reportInstanceStatusRequest.description()));
        }
        if (reportInstanceStatusRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)reportInstanceStatusRequest.endTime()));
        }
        if (!(reportInstanceStatusRequestInstancesList = reportInstanceStatusRequest.instances()).isEmpty() || !(reportInstanceStatusRequestInstancesList instanceof SdkAutoConstructList)) {
            int instancesListIndex = 1;
            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex, StringConversion.fromString((String)reportInstanceStatusRequestInstancesListValue));
                }
                ++instancesListIndex;
            }
        }
        if (!(reportInstanceStatusRequestReasonCodesList = reportInstanceStatusRequest.reasonCodesAsStrings()).isEmpty() || !(reportInstanceStatusRequestReasonCodesList instanceof SdkAutoConstructList)) {
            int reasonCodesListIndex = 1;
            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex, StringConversion.fromString((String)reportInstanceStatusRequestReasonCodesListValue));
                }
                ++reasonCodesListIndex;
            }
        }
        if (reportInstanceStatusRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)reportInstanceStatusRequest.startTime()));
        }
        if (reportInstanceStatusRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString((String)reportInstanceStatusRequest.statusAsString()));
        }
        return request;
    }
}

