/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;

public class RejectVpcEndpointConnectionsRequestMarshaller
implements Marshaller<Request<RejectVpcEndpointConnectionsRequest>, RejectVpcEndpointConnectionsRequest> {
    public Request<RejectVpcEndpointConnectionsRequest> marshall(RejectVpcEndpointConnectionsRequest rejectVpcEndpointConnectionsRequest) {
        List<String> rejectVpcEndpointConnectionsRequestVpcEndpointIdsList;
        if (rejectVpcEndpointConnectionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)rejectVpcEndpointConnectionsRequest, "Ec2Client");
        request.addParameter("Action", "RejectVpcEndpointConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (rejectVpcEndpointConnectionsRequest.serviceId() != null) {
            request.addParameter("ServiceId", StringConversion.fromString((String)rejectVpcEndpointConnectionsRequest.serviceId()));
        }
        if (!(rejectVpcEndpointConnectionsRequestVpcEndpointIdsList = rejectVpcEndpointConnectionsRequest.vpcEndpointIds()).isEmpty() || !(rejectVpcEndpointConnectionsRequestVpcEndpointIdsList instanceof SdkAutoConstructList)) {
            int vpcEndpointIdsListIndex = 1;
            for (String rejectVpcEndpointConnectionsRequestVpcEndpointIdsListValue : rejectVpcEndpointConnectionsRequestVpcEndpointIdsList) {
                if (rejectVpcEndpointConnectionsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringConversion.fromString((String)rejectVpcEndpointConnectionsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

