/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;

public class RegisterImageRequestMarshaller
implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {
    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {
        List<String> registerImageRequestBillingProductsList;
        List<BlockDeviceMapping> registerImageRequestBlockDeviceMappingsList;
        if (registerImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)registerImageRequest, "Ec2Client");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerImageRequest.imageLocation() != null) {
            request.addParameter("ImageLocation", StringConversion.fromString((String)registerImageRequest.imageLocation()));
        }
        if (registerImageRequest.architectureAsString() != null) {
            request.addParameter("Architecture", StringConversion.fromString((String)registerImageRequest.architectureAsString()));
        }
        if (!(registerImageRequestBlockDeviceMappingsList = registerImageRequest.blockDeviceMappings()).isEmpty() || !(registerImageRequestBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (registerImageRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)registerImageRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if (registerImageRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)registerImageRequestBlockDeviceMappingsListValue.virtualName()));
                }
                if ((ebs = registerImageRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.kmsKeyId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringConversion.fromString((String)ebs.kmsKeyId()));
                    }
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeTypeAsString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeTypeAsString()));
                    }
                }
                if (registerImageRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)registerImageRequestBlockDeviceMappingsListValue.noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (registerImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)registerImageRequest.description()));
        }
        if (registerImageRequest.enaSupport() != null) {
            request.addParameter("EnaSupport", StringConversion.fromBoolean((Boolean)registerImageRequest.enaSupport()));
        }
        if (registerImageRequest.kernelId() != null) {
            request.addParameter("KernelId", StringConversion.fromString((String)registerImageRequest.kernelId()));
        }
        if (registerImageRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)registerImageRequest.name()));
        }
        if (!(registerImageRequestBillingProductsList = registerImageRequest.billingProducts()).isEmpty() || !(registerImageRequestBillingProductsList instanceof SdkAutoConstructList)) {
            int billingProductsListIndex = 1;
            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex, StringConversion.fromString((String)registerImageRequestBillingProductsListValue));
                }
                ++billingProductsListIndex;
            }
        }
        if (registerImageRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringConversion.fromString((String)registerImageRequest.ramdiskId()));
        }
        if (registerImageRequest.rootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringConversion.fromString((String)registerImageRequest.rootDeviceName()));
        }
        if (registerImageRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringConversion.fromString((String)registerImageRequest.sriovNetSupport()));
        }
        if (registerImageRequest.virtualizationType() != null) {
            request.addParameter("VirtualizationType", StringConversion.fromString((String)registerImageRequest.virtualizationType()));
        }
        return request;
    }
}

