/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;

public class MoveAddressToVpcRequestMarshaller
implements Marshaller<Request<MoveAddressToVpcRequest>, MoveAddressToVpcRequest> {
    public Request<MoveAddressToVpcRequest> marshall(MoveAddressToVpcRequest moveAddressToVpcRequest) {
        if (moveAddressToVpcRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)moveAddressToVpcRequest, "Ec2Client");
        request.addParameter("Action", "MoveAddressToVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (moveAddressToVpcRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringConversion.fromString((String)moveAddressToVpcRequest.publicIp()));
        }
        return request;
    }
}

