/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;

public class ModifyVpcEndpointServiceConfigurationRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointServiceConfigurationRequest>, ModifyVpcEndpointServiceConfigurationRequest> {
    public Request<ModifyVpcEndpointServiceConfigurationRequest> marshall(ModifyVpcEndpointServiceConfigurationRequest modifyVpcEndpointServiceConfigurationRequest) {
        List<String> modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList;
        List<String> modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList;
        if (modifyVpcEndpointServiceConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcEndpointServiceConfigurationRequest, "Ec2Client");
        request.addParameter("Action", "ModifyVpcEndpointServiceConfiguration");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointServiceConfigurationRequest.serviceId() != null) {
            request.addParameter("ServiceId", StringConversion.fromString((String)modifyVpcEndpointServiceConfigurationRequest.serviceId()));
        }
        if (modifyVpcEndpointServiceConfigurationRequest.acceptanceRequired() != null) {
            request.addParameter("AcceptanceRequired", StringConversion.fromBoolean((Boolean)modifyVpcEndpointServiceConfigurationRequest.acceptanceRequired()));
        }
        if (!(modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList = modifyVpcEndpointServiceConfigurationRequest.addNetworkLoadBalancerArns()).isEmpty() || !(modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList instanceof SdkAutoConstructList)) {
            int addNetworkLoadBalancerArnsListIndex = 1;
            for (String modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue != null) {
                    request.addParameter("AddNetworkLoadBalancerArn." + addNetworkLoadBalancerArnsListIndex, StringConversion.fromString((String)modifyVpcEndpointServiceConfigurationRequestAddNetworkLoadBalancerArnsListValue));
                }
                ++addNetworkLoadBalancerArnsListIndex;
            }
        }
        if (!(modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList = modifyVpcEndpointServiceConfigurationRequest.removeNetworkLoadBalancerArns()).isEmpty() || !(modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList instanceof SdkAutoConstructList)) {
            int removeNetworkLoadBalancerArnsListIndex = 1;
            for (String modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue : modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsList) {
                if (modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue != null) {
                    request.addParameter("RemoveNetworkLoadBalancerArn." + removeNetworkLoadBalancerArnsListIndex, StringConversion.fromString((String)modifyVpcEndpointServiceConfigurationRequestRemoveNetworkLoadBalancerArnsListValue));
                }
                ++removeNetworkLoadBalancerArnsListIndex;
            }
        }
        return request;
    }
}

