/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;

public class ModifyVpcEndpointConnectionNotificationRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointConnectionNotificationRequest>, ModifyVpcEndpointConnectionNotificationRequest> {
    public Request<ModifyVpcEndpointConnectionNotificationRequest> marshall(ModifyVpcEndpointConnectionNotificationRequest modifyVpcEndpointConnectionNotificationRequest) {
        List<String> modifyVpcEndpointConnectionNotificationRequestConnectionEventsList;
        if (modifyVpcEndpointConnectionNotificationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcEndpointConnectionNotificationRequest, "Ec2Client");
        request.addParameter("Action", "ModifyVpcEndpointConnectionNotification");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointConnectionNotificationRequest.connectionNotificationId() != null) {
            request.addParameter("ConnectionNotificationId", StringConversion.fromString((String)modifyVpcEndpointConnectionNotificationRequest.connectionNotificationId()));
        }
        if (modifyVpcEndpointConnectionNotificationRequest.connectionNotificationArn() != null) {
            request.addParameter("ConnectionNotificationArn", StringConversion.fromString((String)modifyVpcEndpointConnectionNotificationRequest.connectionNotificationArn()));
        }
        if (!(modifyVpcEndpointConnectionNotificationRequestConnectionEventsList = modifyVpcEndpointConnectionNotificationRequest.connectionEvents()).isEmpty() || !(modifyVpcEndpointConnectionNotificationRequestConnectionEventsList instanceof SdkAutoConstructList)) {
            int connectionEventsListIndex = 1;
            for (String modifyVpcEndpointConnectionNotificationRequestConnectionEventsListValue : modifyVpcEndpointConnectionNotificationRequestConnectionEventsList) {
                if (modifyVpcEndpointConnectionNotificationRequestConnectionEventsListValue != null) {
                    request.addParameter("ConnectionEvents." + connectionEventsListIndex, StringConversion.fromString((String)modifyVpcEndpointConnectionNotificationRequestConnectionEventsListValue));
                }
                ++connectionEventsListIndex;
            }
        }
        return request;
    }
}

