/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;

public class ModifyVpcAttributeRequestMarshaller
implements Marshaller<Request<ModifyVpcAttributeRequest>, ModifyVpcAttributeRequest> {
    public Request<ModifyVpcAttributeRequest> marshall(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {
        if (modifyVpcAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyVpcAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcAttributeRequest.enableDnsHostnames() != null) {
            request.addParameter("EnableDnsHostnames.Value", StringConversion.fromBoolean((Boolean)modifyVpcAttributeRequest.enableDnsHostnames()));
        }
        if (modifyVpcAttributeRequest.enableDnsSupport() != null) {
            request.addParameter("EnableDnsSupport.Value", StringConversion.fromBoolean((Boolean)modifyVpcAttributeRequest.enableDnsSupport()));
        }
        if (modifyVpcAttributeRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)modifyVpcAttributeRequest.vpcId()));
        }
        return request;
    }
}

