/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration;

public class ModifyReservedInstancesRequestMarshaller
implements Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {
    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {
        List<ReservedInstancesConfiguration> modifyReservedInstancesRequestTargetConfigurationsList;
        if (modifyReservedInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyReservedInstancesRequest, "Ec2Client");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> modifyReservedInstancesRequestReservedInstancesIdsList = modifyReservedInstancesRequest.reservedInstancesIds();
        if (!modifyReservedInstancesRequestReservedInstancesIdsList.isEmpty() || !(modifyReservedInstancesRequestReservedInstancesIdsList instanceof SdkAutoConstructList)) {
            int reservedInstancesIdsListIndex = 1;
            for (String modifyReservedInstancesRequestReservedInstancesIdsListValue : modifyReservedInstancesRequestReservedInstancesIdsList) {
                if (modifyReservedInstancesRequestReservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringConversion.fromString((String)modifyReservedInstancesRequestReservedInstancesIdsListValue));
                }
                ++reservedInstancesIdsListIndex;
            }
        }
        if (modifyReservedInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)modifyReservedInstancesRequest.clientToken()));
        }
        if (!(modifyReservedInstancesRequestTargetConfigurationsList = modifyReservedInstancesRequest.targetConfigurations()).isEmpty() || !(modifyReservedInstancesRequestTargetConfigurationsList instanceof SdkAutoConstructList)) {
            int targetConfigurationsListIndex = 1;
            for (ReservedInstancesConfiguration modifyReservedInstancesRequestTargetConfigurationsListValue : modifyReservedInstancesRequestTargetConfigurationsList) {
                if (modifyReservedInstancesRequestTargetConfigurationsListValue.availabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".AvailabilityZone", StringConversion.fromString((String)modifyReservedInstancesRequestTargetConfigurationsListValue.availabilityZone()));
                }
                if (modifyReservedInstancesRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceCount", StringConversion.fromInteger((Integer)modifyReservedInstancesRequestTargetConfigurationsListValue.instanceCount()));
                }
                if (modifyReservedInstancesRequestTargetConfigurationsListValue.instanceTypeAsString() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceType", StringConversion.fromString((String)modifyReservedInstancesRequestTargetConfigurationsListValue.instanceTypeAsString()));
                }
                if (modifyReservedInstancesRequestTargetConfigurationsListValue.platform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Platform", StringConversion.fromString((String)modifyReservedInstancesRequestTargetConfigurationsListValue.platform()));
                }
                if (modifyReservedInstancesRequestTargetConfigurationsListValue.scopeAsString() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Scope", StringConversion.fromString((String)modifyReservedInstancesRequestTargetConfigurationsListValue.scopeAsString()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

