/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;

public class ModifyInstanceAttributeRequestMarshaller
implements Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {
    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {
        List<String> modifyInstanceAttributeRequestGroupsList;
        List<InstanceBlockDeviceMappingSpecification> modifyInstanceAttributeRequestBlockDeviceMappingsList;
        if (modifyInstanceAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyInstanceAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringConversion.fromBoolean((Boolean)modifyInstanceAttributeRequest.sourceDestCheck()));
        }
        if (modifyInstanceAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)modifyInstanceAttributeRequest.attributeAsString()));
        }
        if (!(modifyInstanceAttributeRequestBlockDeviceMappingsList = modifyInstanceAttributeRequest.blockDeviceMappings()).isEmpty() || !(modifyInstanceAttributeRequestBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
            int blockDeviceMappingsListIndex = 1;
            for (InstanceBlockDeviceMappingSpecification modifyInstanceAttributeRequestBlockDeviceMappingsListValue : modifyInstanceAttributeRequestBlockDeviceMappingsList) {
                EbsInstanceBlockDeviceSpecification ebs;
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if ((ebs = modifyInstanceAttributeRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.volumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId", StringConversion.fromString((String)ebs.volumeId()));
                    }
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice()));
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value", StringConversion.fromBoolean((Boolean)modifyInstanceAttributeRequest.disableApiTermination()));
        }
        if (modifyInstanceAttributeRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized.Value", StringConversion.fromBoolean((Boolean)modifyInstanceAttributeRequest.ebsOptimized()));
        }
        if (modifyInstanceAttributeRequest.enaSupport() != null) {
            request.addParameter("EnaSupport.Value", StringConversion.fromBoolean((Boolean)modifyInstanceAttributeRequest.enaSupport()));
        }
        if (!(modifyInstanceAttributeRequestGroupsList = modifyInstanceAttributeRequest.groups()).isEmpty() || !(modifyInstanceAttributeRequestGroupsList instanceof SdkAutoConstructList)) {
            int groupsListIndex = 1;
            for (String modifyInstanceAttributeRequestGroupsListValue : modifyInstanceAttributeRequestGroupsList) {
                if (modifyInstanceAttributeRequestGroupsListValue != null) {
                    request.addParameter("GroupId." + groupsListIndex, StringConversion.fromString((String)modifyInstanceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)modifyInstanceAttributeRequest.instanceId()));
        }
        if (modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior()));
        }
        if (modifyInstanceAttributeRequest.instanceType() != null) {
            request.addParameter("InstanceType.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.instanceType()));
        }
        if (modifyInstanceAttributeRequest.kernel() != null) {
            request.addParameter("Kernel.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.kernel()));
        }
        if (modifyInstanceAttributeRequest.ramdisk() != null) {
            request.addParameter("Ramdisk.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.ramdisk()));
        }
        if (modifyInstanceAttributeRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.sriovNetSupport()));
        }
        if (modifyInstanceAttributeRequest.userData() != null) {
            request.addParameter("UserData.Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.userData()));
        }
        if (modifyInstanceAttributeRequest.value() != null) {
            request.addParameter("Value", StringConversion.fromString((String)modifyInstanceAttributeRequest.value()));
        }
        return request;
    }
}

