/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        List<String> modifyImageAttributeRequestUserIdsList;
        List<String> modifyImageAttributeRequestUserGroupsList;
        List<String> modifyImageAttributeRequestProductCodesList;
        LaunchPermissionModifications launchPermission;
        if (modifyImageAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyImageAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)modifyImageAttributeRequest.attribute()));
        }
        if (modifyImageAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringConversion.fromString((String)modifyImageAttributeRequest.description()));
        }
        if (modifyImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString((String)modifyImageAttributeRequest.imageId()));
        }
        if ((launchPermission = modifyImageAttributeRequest.launchPermission()) != null) {
            List<LaunchPermission> launchPermissionModificationsRemoveList;
            List<LaunchPermission> launchPermissionModificationsAddList = launchPermission.add();
            if (!launchPermissionModificationsAddList.isEmpty() || !(launchPermissionModificationsAddList instanceof SdkAutoConstructList)) {
                int addListIndex = 1;
                for (LaunchPermission launchPermission2 : launchPermissionModificationsAddList) {
                    if (launchPermission2.groupAsString() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringConversion.fromString((String)launchPermission2.groupAsString()));
                    }
                    if (launchPermission2.userId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringConversion.fromString((String)launchPermission2.userId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(launchPermissionModificationsRemoveList = launchPermission.remove()).isEmpty() || !(launchPermissionModificationsRemoveList instanceof SdkAutoConstructList)) {
                int removeListIndex = 1;
                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {
                    if (launchPermissionModificationsRemoveListValue.groupAsString() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringConversion.fromString((String)launchPermissionModificationsRemoveListValue.groupAsString()));
                    }
                    if (launchPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringConversion.fromString((String)launchPermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.operationTypeAsString() != null) {
            request.addParameter("OperationType", StringConversion.fromString((String)modifyImageAttributeRequest.operationTypeAsString()));
        }
        if (!(modifyImageAttributeRequestProductCodesList = modifyImageAttributeRequest.productCodes()).isEmpty() || !(modifyImageAttributeRequestProductCodesList instanceof SdkAutoConstructList)) {
            int productCodesListIndex = 1;
            for (String string : modifyImageAttributeRequestProductCodesList) {
                if (string != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringConversion.fromString((String)string));
                }
                ++productCodesListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserGroupsList = modifyImageAttributeRequest.userGroups()).isEmpty() || !(modifyImageAttributeRequestUserGroupsList instanceof SdkAutoConstructList)) {
            int userGroupsListIndex = 1;
            for (String modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringConversion.fromString((String)modifyImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserIdsList = modifyImageAttributeRequest.userIds()).isEmpty() || !(modifyImageAttributeRequestUserIdsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                void var7_21;
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + (int)var7_21, StringConversion.fromString((String)modifyImageAttributeRequestUserIdsListValue));
                }
                ++var7_21;
            }
        }
        if (modifyImageAttributeRequest.value() != null) {
            request.addParameter("Value", StringConversion.fromString((String)modifyImageAttributeRequest.value()));
        }
        return request;
    }
}

