/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;

public class ModifyIdFormatRequestMarshaller
implements Marshaller<Request<ModifyIdFormatRequest>, ModifyIdFormatRequest> {
    public Request<ModifyIdFormatRequest> marshall(ModifyIdFormatRequest modifyIdFormatRequest) {
        if (modifyIdFormatRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyIdFormatRequest, "Ec2Client");
        request.addParameter("Action", "ModifyIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIdFormatRequest.resource() != null) {
            request.addParameter("Resource", StringConversion.fromString((String)modifyIdFormatRequest.resource()));
        }
        if (modifyIdFormatRequest.useLongIds() != null) {
            request.addParameter("UseLongIds", StringConversion.fromBoolean((Boolean)modifyIdFormatRequest.useLongIds()));
        }
        return request;
    }
}

