/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;

public class ModifyFleetRequestMarshaller
implements Marshaller<Request<ModifyFleetRequest>, ModifyFleetRequest> {
    public Request<ModifyFleetRequest> marshall(ModifyFleetRequest modifyFleetRequest) {
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        if (modifyFleetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyFleetRequest, "Ec2Client");
        request.addParameter("Action", "ModifyFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFleetRequest.excessCapacityTerminationPolicyAsString() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringConversion.fromString((String)modifyFleetRequest.excessCapacityTerminationPolicyAsString()));
        }
        if (modifyFleetRequest.fleetId() != null) {
            request.addParameter("FleetId", StringConversion.fromString((String)modifyFleetRequest.fleetId()));
        }
        if ((targetCapacitySpecification = modifyFleetRequest.targetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.totalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.totalTargetCapacity()));
            }
            if (targetCapacitySpecification.onDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.onDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.spotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringConversion.fromInteger((Integer)targetCapacitySpecification.spotTargetCapacity()));
            }
            if (targetCapacitySpecification.defaultTargetCapacityTypeAsString() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringConversion.fromString((String)targetCapacitySpecification.defaultTargetCapacityTypeAsString()));
            }
        }
        return request;
    }
}

