/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class LaunchTemplateUnmarshaller
implements Unmarshaller<LaunchTemplate, StaxUnmarshallerContext> {
    private static final LaunchTemplateUnmarshaller INSTANCE = new LaunchTemplateUnmarshaller();

    public LaunchTemplate unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchTemplate.Builder launchTemplate;
        block11: {
            launchTemplate = LaunchTemplate.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    launchTemplate.tags(tags);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("launchTemplateId", targetDepth)) {
                        launchTemplate.launchTemplateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchTemplateName", targetDepth)) {
                        launchTemplate.launchTemplateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("createTime", targetDepth)) {
                        launchTemplate.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("createdBy", targetDepth)) {
                        launchTemplate.createdBy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("defaultVersionNumber", targetDepth)) {
                        launchTemplate.defaultVersionNumber(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("latestVersionNumber", targetDepth)) {
                        launchTemplate.latestVersionNumber(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            launchTemplate.tags(tags);
        }
        return (LaunchTemplate)launchTemplate.build();
    }

    public static LaunchTemplateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

