/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification launchSpecification;
        List<DiskImage> importInstanceRequestDiskImagesList;
        if (importInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)importInstanceRequest, "Ec2Client");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)importInstanceRequest.description()));
        }
        if (!(importInstanceRequestDiskImagesList = importInstanceRequest.diskImages()).isEmpty() || !(importInstanceRequestDiskImagesList instanceof SdkAutoConstructList)) {
            int diskImagesListIndex = 1;
            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {
                VolumeDetail volumeDetail;
                Object image;
                if (importInstanceRequestDiskImagesListValue.description() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringConversion.fromString((String)importInstanceRequestDiskImagesListValue.description()));
                }
                if ((image = importInstanceRequestDiskImagesListValue.image()) != null) {
                    if (((DiskImageDetail)image).bytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringConversion.fromLong((Long)((DiskImageDetail)image).bytes()));
                    }
                    if (((DiskImageDetail)image).formatAsString() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringConversion.fromString((String)((DiskImageDetail)image).formatAsString()));
                    }
                    if (((DiskImageDetail)image).importManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringConversion.fromString((String)((DiskImageDetail)image).importManifestUrl()));
                    }
                }
                if ((volumeDetail = importInstanceRequestDiskImagesListValue.volume()) != null && volumeDetail.size() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringConversion.fromLong((Long)volumeDetail.size()));
                }
                ++diskImagesListIndex;
            }
        }
        if ((launchSpecification = importInstanceRequest.launchSpecification()) != null) {
            UserData userData;
            Placement placement;
            List<String> importInstanceLaunchSpecificationGroupNamesList;
            List<String> importInstanceLaunchSpecificationGroupIdsList;
            if (launchSpecification.additionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringConversion.fromString((String)launchSpecification.additionalInfo()));
            }
            if (launchSpecification.architectureAsString() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringConversion.fromString((String)launchSpecification.architectureAsString()));
            }
            if (!(importInstanceLaunchSpecificationGroupIdsList = launchSpecification.groupIds()).isEmpty() || !(importInstanceLaunchSpecificationGroupIdsList instanceof SdkAutoConstructList)) {
                int groupIdsListIndex = 1;
                for (String string : importInstanceLaunchSpecificationGroupIdsList) {
                    if (string != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringConversion.fromString((String)string));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (!(importInstanceLaunchSpecificationGroupNamesList = launchSpecification.groupNames()).isEmpty() || !(importInstanceLaunchSpecificationGroupNamesList instanceof SdkAutoConstructList)) {
                int groupNamesListIndex = 1;
                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringConversion.fromString((String)importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (launchSpecification.instanceInitiatedShutdownBehaviorAsString() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringConversion.fromString((String)launchSpecification.instanceInitiatedShutdownBehaviorAsString()));
            }
            if (launchSpecification.instanceTypeAsString() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringConversion.fromString((String)launchSpecification.instanceTypeAsString()));
            }
            if (launchSpecification.monitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringConversion.fromBoolean((Boolean)launchSpecification.monitoring()));
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
                }
                if (placement.affinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringConversion.fromString((String)placement.affinity()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
                }
                if (placement.hostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringConversion.fromString((String)placement.hostId()));
                }
                if (placement.tenancyAsString() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringConversion.fromString((String)placement.tenancyAsString()));
                }
                if (placement.spreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain", StringConversion.fromString((String)placement.spreadDomain()));
                }
            }
            if (launchSpecification.privateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringConversion.fromString((String)launchSpecification.privateIpAddress()));
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringConversion.fromString((String)launchSpecification.subnetId()));
            }
            if ((userData = launchSpecification.userData()) != null && userData.data() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringConversion.fromString((String)userData.data()));
            }
        }
        if (importInstanceRequest.platformAsString() != null) {
            request.addParameter("Platform", StringConversion.fromString((String)importInstanceRequest.platformAsString()));
        }
        return request;
    }
}

