/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.transform.DiskImageDetailUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VolumeDetailUnmarshaller;

public class DiskImageUnmarshaller
implements Unmarshaller<DiskImage, StaxUnmarshallerContext> {
    private static final DiskImageUnmarshaller INSTANCE = new DiskImageUnmarshaller();

    public DiskImage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DiskImage.Builder diskImage = DiskImage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Description", targetDepth)) {
                    diskImage.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Image", targetDepth)) {
                    diskImage.image(DiskImageDetailUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Volume", targetDepth)) continue;
                diskImage.volume(VolumeDetailUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DiskImage)diskImage.build();
    }

    public static DiskImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

