/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcPeeringConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcPeeringConnectionsRequest>, DescribeVpcPeeringConnectionsRequest> {
    public Request<DescribeVpcPeeringConnectionsRequest> marshall(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        List<String> describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList;
        if (describeVpcPeeringConnectionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcPeeringConnectionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcPeeringConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpcPeeringConnectionsRequestFiltersList = describeVpcPeeringConnectionsRequest.filters();
        if (!describeVpcPeeringConnectionsRequestFiltersList.isEmpty() || !(describeVpcPeeringConnectionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcPeeringConnectionsRequestFiltersListValue : describeVpcPeeringConnectionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcPeeringConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcPeeringConnectionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcPeeringConnectionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList = describeVpcPeeringConnectionsRequest.vpcPeeringConnectionIds()).isEmpty() || !(describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList instanceof SdkAutoConstructList)) {
            int vpcPeeringConnectionIdsListIndex = 1;
            for (String describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue : describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList) {
                if (describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue != null) {
                    request.addParameter("VpcPeeringConnectionId." + vpcPeeringConnectionIdsListIndex, StringConversion.fromString((String)describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue));
                }
                ++vpcPeeringConnectionIdsListIndex;
            }
        }
        return request;
    }
}

