/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        List<String> list;
        List<String> describeSnapshotsRequestRestorableByUserIdsList;
        List<String> describeSnapshotsRequestOwnerIdsList;
        if (describeSnapshotsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSnapshotsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSnapshotsRequestFiltersList = describeSnapshotsRequest.filters();
        if (!describeSnapshotsRequestFiltersList.isEmpty() || !(describeSnapshotsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter filter : describeSnapshotsRequestFiltersList) {
                List<String> list2;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filter.name()));
                }
                if (!(list2 = filter.values()).isEmpty() || !(list2 instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : list2) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSnapshotsRequest.maxResults()));
        }
        if (describeSnapshotsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSnapshotsRequest.nextToken()));
        }
        if (!(describeSnapshotsRequestOwnerIdsList = describeSnapshotsRequest.ownerIds()).isEmpty() || !(describeSnapshotsRequestOwnerIdsList instanceof SdkAutoConstructList)) {
            int ownerIdsListIndex = 1;
            for (String string : describeSnapshotsRequestOwnerIdsList) {
                if (string != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringConversion.fromString((String)string));
                }
                ++ownerIdsListIndex;
            }
        }
        if (!(describeSnapshotsRequestRestorableByUserIdsList = describeSnapshotsRequest.restorableByUserIds()).isEmpty() || !(describeSnapshotsRequestRestorableByUserIdsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeSnapshotsRequestRestorableByUserIdsListValue : describeSnapshotsRequestRestorableByUserIdsList) {
                void var6_12;
                if (describeSnapshotsRequestRestorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + (int)var6_12, StringConversion.fromString((String)describeSnapshotsRequestRestorableByUserIdsListValue));
                }
                ++var6_12;
            }
        }
        if (!(list = describeSnapshotsRequest.snapshotIds()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeSnapshotsRequestSnapshotIdsListValue : list) {
                void var7_20;
                if (describeSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + (int)var7_20, StringConversion.fromString((String)describeSnapshotsRequestSnapshotIdsListValue));
                }
                ++var7_20;
            }
        }
        return request;
    }
}

