/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        List<String> describeSecurityGroupsRequestGroupNamesList;
        List<String> describeSecurityGroupsRequestGroupIdsList;
        if (describeSecurityGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSecurityGroupsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSecurityGroupsRequestFiltersList = describeSecurityGroupsRequest.filters();
        if (!describeSecurityGroupsRequestFiltersList.isEmpty() || !(describeSecurityGroupsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter filter : describeSecurityGroupsRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filter.name()));
                }
                if (!(filterValuesList = filter.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupIdsList = describeSecurityGroupsRequest.groupIds()).isEmpty() || !(describeSecurityGroupsRequestGroupIdsList instanceof SdkAutoConstructList)) {
            int groupIdsListIndex = 1;
            for (String describeSecurityGroupsRequestGroupIdsListValue : describeSecurityGroupsRequestGroupIdsList) {
                if (describeSecurityGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringConversion.fromString((String)describeSecurityGroupsRequestGroupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupNamesList = describeSecurityGroupsRequest.groupNames()).isEmpty() || !(describeSecurityGroupsRequestGroupNamesList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeSecurityGroupsRequestGroupNamesListValue : describeSecurityGroupsRequestGroupNamesList) {
                void var6_12;
                if (describeSecurityGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + (int)var6_12, StringConversion.fromString((String)describeSecurityGroupsRequestGroupNamesListValue));
                }
                ++var6_12;
            }
        }
        if (describeSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeSecurityGroupsRequest.nextToken()));
        }
        if (describeSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeSecurityGroupsRequest.maxResults()));
        }
        return request;
    }
}

