/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesListingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesListingsRequest>, DescribeReservedInstancesListingsRequest> {
    public Request<DescribeReservedInstancesListingsRequest> marshall(DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {
        if (describeReservedInstancesListingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedInstancesListingsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeReservedInstancesListings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeReservedInstancesListingsRequestFiltersList = describeReservedInstancesListingsRequest.filters();
        if (!describeReservedInstancesListingsRequestFiltersList.isEmpty() || !(describeReservedInstancesListingsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesListingsRequestFiltersListValue : describeReservedInstancesListingsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesListingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeReservedInstancesListingsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeReservedInstancesListingsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringConversion.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesId()));
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesListingId() != null) {
            request.addParameter("ReservedInstancesListingId", StringConversion.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesListingId()));
        }
        return request;
    }
}

