/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;

public class DescribePrincipalIdFormatRequestMarshaller
implements Marshaller<Request<DescribePrincipalIdFormatRequest>, DescribePrincipalIdFormatRequest> {
    public Request<DescribePrincipalIdFormatRequest> marshall(DescribePrincipalIdFormatRequest describePrincipalIdFormatRequest) {
        if (describePrincipalIdFormatRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describePrincipalIdFormatRequest, "Ec2Client");
        request.addParameter("Action", "DescribePrincipalIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describePrincipalIdFormatRequestResourcesList = describePrincipalIdFormatRequest.resources();
        if (!describePrincipalIdFormatRequestResourcesList.isEmpty() || !(describePrincipalIdFormatRequestResourcesList instanceof SdkAutoConstructList)) {
            int resourcesListIndex = 1;
            for (String describePrincipalIdFormatRequestResourcesListValue : describePrincipalIdFormatRequestResourcesList) {
                if (describePrincipalIdFormatRequestResourcesListValue != null) {
                    request.addParameter("Resource." + resourcesListIndex, StringConversion.fromString((String)describePrincipalIdFormatRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (describePrincipalIdFormatRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describePrincipalIdFormatRequest.maxResults()));
        }
        if (describePrincipalIdFormatRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describePrincipalIdFormatRequest.nextToken()));
        }
        return request;
    }
}

